


export class EmailTemplateEditWidget {
	
	
	tpl = `
		<div class="email-template-edit-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
					<a [onclick]="widget.save_Click" class="fa fa-save"></a>
				</div>
				
				
				<h1>{{_('Edit template')}}</h1>
			</div>
			
			<div ez-if="loading">Loading...</div>
			
			<div ez-if="loading == false">
				<form id="frmTemplate">
					
					<div class="template-name">
						{{t.name}}
					</div>
					
					<ez-text name="fromName"
								[value]="t.fromName"
								label="{{_('From name')}}"></ez-text>
					<ez-text name="fromEmail"
								[value]="t.fromEmail"
								label="{{_('From email')}}"></ez-text>
					<ez-text name="subject"
								[value]="t.subject"
								label="{{_('Subject')}}"></ez-text>
					<ez-textarea name="content"
								[value]="t.content"
								label="{{_('Content')}}"></ez-textarea>
				</form>
				
				
				<div ez-if="templateTags.length > 0" class="template-tags-container">
					<h2>{{_('Template tags')}}</h2>
					<table class="table">
						<thead>
							<tr>
								<th style="width: 150px;">{{_('Code')}}</th>
								<th>{{_('Description')}}</th>
							</tr>
						</thead>
						<tbody ez-for="templateTags" ez-item="t">
							<tr>
								<td>{{t.code}}</td>
								<td>{{t.description}}</td>
							</tr>
						</tbody>
					</table>
				</div>
				
			</div>
			
			
		</div>
		
	`;
	
	
	container = null;
	
	loading = true;
	
	template = {};
	
	
	init(e) {
		loadCss( '/static/app/widget/email/css/email.css' );
		
		this.container = e;
		
		this.render();
		
		this.load();
	}
	
	
	async load() {
		
		let id = getUrlParam('id');
		
		let r = await postJson('/service/email/template.do', {
			a: 'view',
			id: id
		});
		
		let json = await r.json();
		this.template = json.emailTemplate;
		this.loading = false;
		
		this.render();
	}
	
	
	render() {
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('t', this.template);
		
		let tags = this.getTemplateTags(this.template);
//		console.log( tags );
		eztpl.setVar('templateTags', tags);
		
		eztpl.render();
		
		$(this.container).find('input[name=fromName], input[name=fromEmail], input[name=subject]').on('change', function() {
			this.value = trim(this.value);
		})
		
		
		var strPlugins = 'paste,code,link,media,paste,table,textcolor,wordcount,contextmenu,colorpicker';
		$('textarea[name=content]').tinymce({
			plugins: strPlugins,
			paste_data_images: true
		});
		
	}
	
	
	
	back_Click() {
		gotoRoute( '/email/templates/' );
	}
	
	
	async save_Click() {
		
		let frm = document.querySelector('#frmTemplate');
		
		this.template.fromName  = frm.querySelector('input[name=fromName]').value;
		this.template.fromEmail = frm.querySelector('input[name=fromEmail]').value;
		this.template.subject   = frm.querySelector('input[name=subject]').value;
		this.template.content   = $(frm).find('textarea[name=content]').val();
		
		showLoadingForm( '#frmTemplate' );
		
		let r = await postJson('/service/email/template.do', {
			a: 'save',
			template: this.template
		});
		
		let json = await r.json();
		
		reportUserMessage( _('Changes saved') );
		
		hideLoadingForm( '#frmTemplate' );
		
		replaceRoute( '/email/templates/edit/?id=' + json.emailTemplate.emailTemplateId );
		
	}
	
	
	
	getTemplateTags( template ) {
		
		if (template == null || template.length == 0)
			return [];
		
		let tags = [];
		
		
		if (template.templateCode == 'RESET_PASSWORD') {
			tags.push({
				code: '[[link]]',
				description: 'Link naar reset-wachtwoord pagina'
			})
		}
		
		if (template.templateCode == 'R2B_APP_AUTH') {
			tags.push({
				code: '[[link]]',
				description: _('Link to automatically sign in to the app')
			})
		}

		tags = apply_filter('EmailTemplateEditWidget.getTemplateTags', tags, template);
		
		return tags;
	}
	
	
	
	
}



